<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Secure Browser License Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; display: flex; align-items: center; }
        .card { border: none; border-radius: 15px; box-shadow: 0 10px 40px rgba(0,0,0,0.2); }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body text-center p-5">
                        <h1 class="mb-4">Secure Browser License Management</h1>
                        <p class="lead text-muted mb-5">Manage license keys, users, and settings for the Secure Browser application.</p>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="card bg-dark text-white h-100">
                                    <div class="card-body">
                                        <h4>Super Admin Panel</h4>
                                        <p class="small">Manage license keys and view system-wide statistics</p>
                                        <a href="/superadmin/login" class="btn btn-light">Login as Super Admin</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="card bg-primary text-white h-100">
                                    <div class="card-body">
                                        <h4>Admin Panel</h4>
                                        <p class="small">Manage users, settings, and license activation</p>
                                        <a href="/admin/login" class="btn btn-light">Login as Admin</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <hr class="my-4">
                        <div class="text-start">
                            <p class="text-muted small mb-2"><strong>Desktop App API Endpoints:</strong></p>
                            
                            <div class="mb-3 p-3 bg-light rounded">
                                <code class="text-primary fw-bold">POST /api/desktop/authenticate</code>
                                <p class="text-muted small mb-1 mt-2">Registers system and returns license settings</p>
                                <p class="text-muted small mb-2"><strong>Request:</strong> <code>mac_address</code>, <code>ip_address</code>, <code>hostname</code></p>
                                <p class="text-muted small mb-0"><strong>Response:</strong> <code>LmsProbeOrigin</code>, <code>licence_valid</code>, <code>login_needed</code>, <code>detect_camera</code>, <code>detect_person</code>, <code>screenshot_needed</code>, <code>default_login_api</code>, <code>msg</code>, <code>SapWebUrl</code></p>
                            </div>
                            
                            <div class="p-3 bg-light rounded">
                                <code class="text-success fw-bold">POST /api/desktop/login</code>
                                <p class="text-muted small mb-1 mt-2">User login (only if login_needed = true)</p>
                                <p class="text-muted small mb-0"><strong>Request:</strong> <code>user_id</code>, <code>password</code></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
