<?= $this->extend('layouts/superadmin') ?>

<?= $this->section('content') ?>
<h2 class="mb-4">Registered Desktops</h2>

<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">Select License</h5>
    </div>
    <div class="card-body">
        <form method="get" action="/superadmin/reported-systems" class="row g-3 align-items-end">
            <div class="col-md-8">
                <label for="license_id" class="form-label">License Key - Organization</label>
                <select name="license_id" id="license_id" class="form-select" onchange="this.form.submit()">
                    <option value="">-- Select a License --</option>
                    <?php foreach($licenses as $license): ?>
                    <option value="<?= $license['id'] ?>" <?= $selectedLicenseId == $license['id'] ? 'selected' : '' ?>>
                        <?= esc($license['license_code']) ?> - <?= esc($license['organization_name']) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-4">
                <button type="submit" class="btn btn-primary">View Desktops</button>
            </div>
        </form>
    </div>
</div>

<?php if($selectedLicense): ?>
<div class="card mb-4">
    <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0">
            <?= esc($selectedLicense['organization_name']) ?> - Desktop Registrations
        </h5>
        <span class="badge bg-light text-dark">
            <?= count($registeredSystems) ?> direct + <?= count($reportedSystems) ?> reported / <?= $selectedLicense['max_seats'] == -1 ? 'Unlimited' : $selectedLicense['max_seats'] ?> seats
        </span>
    </div>
    <div class="card-body p-0">
        <div class="p-3 bg-light border-bottom">
            <div class="row">
                <div class="col-md-4"><strong>License Code:</strong> <code><?= esc($selectedLicense['license_code']) ?></code></div>
                <div class="col-md-4"><strong>Status:</strong> <span class="badge bg-<?= $selectedLicense['status'] == 'active' ? 'success' : 'secondary' ?>"><?= ucfirst($selectedLicense['status']) ?></span></div>
                <div class="col-md-4"><strong>Valid Until:</strong> <?= $selectedLicense['valid_until'] ? date('M d, Y', strtotime($selectedLicense['valid_until'])) : 'No expiry' ?></div>
            </div>
        </div>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header bg-success text-white">
        <h5 class="mb-0">Registered Desktops (Direct) - <?= count($registeredSystems) ?></h5>
    </div>
    <div class="card-body p-0">
        <?php if(empty($registeredSystems)): ?>
            <div class="p-4 text-center text-muted">
                No desktop systems registered directly yet.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>Hostname</th>
                            <th>MAC Hash</th>
                            <th>IP Address</th>
                            <th>First Seen</th>
                            <th>Last Seen</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($registeredSystems as $system): ?>
                        <tr>
                            <td><?= esc($system['hostname']) ?: '-' ?></td>
                            <td><code class="small"><?= esc(substr($system['mac_hash'], 0, 12)) ?>...</code></td>
                            <td><?= esc($system['ip_address']) ?: '-' ?></td>
                            <td><?= $system['first_seen_at'] ? date('M d, Y H:i', strtotime($system['first_seen_at'])) : '-' ?></td>
                            <td><?= $system['last_seen_at'] ? date('M d, Y H:i', strtotime($system['last_seen_at'])) : '-' ?></td>
                            <td><span class="badge bg-<?= $system['status'] == 'active' ? 'success' : 'secondary' ?>"><?= ucfirst($system['status']) ?></span></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0">Reported Desktops (From Admin Deployments) - <?= count($reportedSystems) ?></h5>
    </div>
    <div class="card-body p-0">
        <?php if(empty($reportedSystems)): ?>
            <div class="p-4 text-center text-muted">
                No desktop systems have been reported by Admin deployments yet.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>Hostname</th>
                            <th>MAC Hash</th>
                            <th>IP Address</th>
                            <th>User</th>
                            <th>Admin Source</th>
                            <th>First Seen</th>
                            <th>Last Seen</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($reportedSystems as $system): ?>
                        <tr>
                            <td><?= esc($system['hostname']) ?: '-' ?></td>
                            <td><code class="small"><?= esc(substr($system['mac_hash'], 0, 12)) ?>...</code></td>
                            <td><?= esc($system['ip_address']) ?: '-' ?></td>
                            <td>
                                <?php if($system['user_name']): ?>
                                    <?= esc($system['user_name']) ?>
                                    <small class="text-muted d-block"><?= esc($system['user_id']) ?></small>
                                <?php else: ?>
                                    <?= esc($system['user_id']) ?: '-' ?>
                                <?php endif; ?>
                            </td>
                            <td><small><?= esc($system['admin_source']) ?: '-' ?></small></td>
                            <td><?= $system['first_seen_at'] ? date('M d, Y H:i', strtotime($system['first_seen_at'])) : '-' ?></td>
                            <td><?= $system['last_seen_at'] ? date('M d, Y H:i', strtotime($system['last_seen_at'])) : '-' ?></td>
                            <td><span class="badge bg-<?= $system['status'] == 'active' ? 'success' : 'secondary' ?>"><?= ucfirst($system['status']) ?></span></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php elseif(!$selectedLicenseId): ?>
<div class="alert alert-info">
    Please select a license from the dropdown above to view registered desktops.
</div>
<?php endif; ?>
<?= $this->endSection() ?>
