<?= $this->extend('layouts/superadmin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>License Details</h2>
    <div>
        <a href="/superadmin/licenses/edit/<?= $license['id'] ?>" class="btn btn-warning">
            <i class="bi bi-pencil"></i> Edit
        </a>
        <a href="/superadmin/licenses" class="btn btn-outline-secondary">Back</a>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header"><h5 class="mb-0">License Information</h5></div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <th width="40%">License Code:</th>
                        <td><code><?= esc($license['license_code']) ?></code>
                            <button class="btn btn-sm btn-outline-secondary" onclick="navigator.clipboard.writeText('<?= esc($license['license_code']) ?>'); alert('Copied!');">Copy</button>
                        </td>
                    </tr>
                    <tr>
                        <th>Organization:</th>
                        <td><?= esc($license['organization_name']) ?: '-' ?></td>
                    </tr>
                    <tr>
                        <th>Contact Email:</th>
                        <td><?= esc($license['contact_email'] ?? '') ?: '-' ?></td>
                    </tr>
                    <tr>
                        <th>Contact Phone:</th>
                        <td><?= esc($license['contact_phone'] ?? '') ?: '-' ?></td>
                    </tr>
                    <tr>
                        <th>Status:</th>
                        <td><span class="badge bg-<?= $license['status'] == 'active' ? 'success' : ($license['status'] == 'expired' ? 'danger' : 'secondary') ?>"><?= esc(ucfirst($license['status'])) ?></span></td>
                    </tr>
                    <tr>
                        <th>Max Seats:</th>
                        <td><?= $license['max_seats'] == -1 ? 'Unlimited' : $license['max_seats'] ?></td>
                    </tr>
                    <tr>
                        <th>Used Seats:</th>
                        <td><?= $license['used_seats'] ?></td>
                    </tr>
                    <tr>
                        <th>Valid From:</th>
                        <td><?= $license['valid_from'] ? date('M d, Y', strtotime($license['valid_from'])) : '-' ?></td>
                    </tr>
                    <tr>
                        <th>Valid Until:</th>
                        <td><?= $license['valid_until'] ? date('M d, Y', strtotime($license['valid_until'])) : '-' ?></td>
                    </tr>
                    <tr>
                        <th>Notes:</th>
                        <td><?= esc($license['notes']) ?: '-' ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header"><h5 class="mb-0">Settings</h5></div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <th width="50%">Login Screen:</th>
                        <td><span class="badge bg-<?= $license['enable_login_screen'] ? 'success' : 'secondary' ?>"><?= $license['enable_login_screen'] ? 'Yes' : 'No' ?></span></td>
                    </tr>
                    <tr>
                        <th>Camera Detection:</th>
                        <td><span class="badge bg-<?= $license['enable_camera_detection'] ? 'success' : 'secondary' ?>"><?= $license['enable_camera_detection'] ? 'Enabled' : 'Disabled' ?></span></td>
                    </tr>
                    <tr>
                        <th>Person Detection:</th>
                        <td><span class="badge bg-<?= $license['enable_person_detection'] ? 'success' : 'secondary' ?>"><?= $license['enable_person_detection'] ? 'Enabled' : 'Disabled' ?></span></td>
                    </tr>
                    <tr>
                        <th>Screenshot:</th>
                        <td><span class="badge bg-<?= ($license['screenshot_needed'] ?? 0) ? 'success' : 'secondary' ?>"><?= ($license['screenshot_needed'] ?? 0) ? 'Enabled' : 'Disabled' ?></span></td>
                    </tr>
                    <tr>
                        <th>LMS Probe Origin:</th>
                        <td><?= esc($license['lms_probe_origin'] ?? '') ?: '<span class="text-muted">-</span>' ?></td>
                    </tr>
                    <tr>
                        <th>SAP Web URL:</th>
                        <td><?= esc($license['sap_web_url'] ?? '') ?: '<span class="text-muted">-</span>' ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header bg-success text-white">
        <h5 class="mb-0">Registered Desktops (Direct)</h5>
    </div>
    <div class="card-body">
        <?php if(empty($registeredSystems)): ?>
            <p class="text-muted mb-0">No desktop systems have been registered directly yet.</p>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Hostname</th>
                            <th>IP Address</th>
                            <th>MAC Hash</th>
                            <th>First Seen</th>
                            <th>Last Seen</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($registeredSystems as $i => $system): ?>
                        <tr>
                            <td><?= $i + 1 ?></td>
                            <td><?= esc($system['hostname']) ?: '-' ?></td>
                            <td><?= esc($system['ip_address']) ?: '-' ?></td>
                            <td><code><?= substr($system['mac_hash'], 0, 12) ?>...</code></td>
                            <td><?= $system['first_seen_at'] ? date('M d, Y H:i', strtotime($system['first_seen_at'])) : '-' ?></td>
                            <td><?= $system['last_seen_at'] ? date('M d, Y H:i', strtotime($system['last_seen_at'])) : '-' ?></td>
                            <td><span class="badge bg-<?= $system['status'] == 'active' ? 'success' : 'secondary' ?>"><?= ucfirst($system['status']) ?></span></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-2">
                <small class="text-muted">
                    Total: <?= count($registeredSystems) ?> system(s) | 
                    Active: <?= count(array_filter($registeredSystems, fn($s) => $s['status'] === 'active')) ?>
                </small>
            </div>
        <?php endif; ?>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0">Reported Desktops (From Admin Deployments)</h5>
    </div>
    <div class="card-body">
        <?php if(empty($reportedSystems)): ?>
            <p class="text-muted mb-0">No desktop systems have been reported by Admin deployments yet.</p>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Hostname</th>
                            <th>User</th>
                            <th>IP Address</th>
                            <th>Admin Source</th>
                            <th>First Seen</th>
                            <th>Last Seen</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($reportedSystems as $i => $system): ?>
                        <tr>
                            <td><?= $i + 1 ?></td>
                            <td><?= esc($system['hostname']) ?: '-' ?></td>
                            <td>
                                <?php if($system['user_name']): ?>
                                    <?= esc($system['user_name']) ?>
                                    <small class="text-muted d-block"><?= esc($system['user_id']) ?></small>
                                <?php else: ?>
                                    <?= esc($system['user_id']) ?: '-' ?>
                                <?php endif; ?>
                            </td>
                            <td><?= esc($system['ip_address']) ?: '-' ?></td>
                            <td><small><?= esc($system['admin_source']) ?: '-' ?></small></td>
                            <td><?= $system['first_seen_at'] ? date('M d, Y H:i', strtotime($system['first_seen_at'])) : '-' ?></td>
                            <td><?= $system['last_seen_at'] ? date('M d, Y H:i', strtotime($system['last_seen_at'])) : '-' ?></td>
                            <td><span class="badge bg-<?= $system['status'] == 'active' ? 'success' : 'secondary' ?>"><?= ucfirst($system['status']) ?></span></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-2">
                <small class="text-muted">
                    Total: <?= count($reportedSystems) ?> system(s) | 
                    Active: <?= count(array_filter($reportedSystems, fn($s) => $s['status'] === 'active')) ?>
                </small>
            </div>
        <?php endif; ?>
    </div>
</div>

<div class="card">
    <div class="card-header"><h5 class="mb-0">System Usage (Legacy)</h5></div>
    <div class="card-body">
        <?php if(empty($systemUsage)): ?>
            <p class="text-muted mb-0">No systems have used this license yet.</p>
        <?php else: ?>
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>MAC ID</th>
                        <th>IP Address</th>
                        <th>Action</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($systemUsage as $i => $usage): ?>
                    <tr>
                        <td><?= $i + 1 ?></td>
                        <td><code><?= esc($usage['mac_id'] ?? '-') ?></code></td>
                        <td><?= esc($usage['ip_address'] ?? '-') ?></td>
                        <td><?= esc($usage['action'] ?? '-') ?></td>
                        <td><?= $usage['created_at'] ? date('M d, Y H:i', strtotime($usage['created_at'])) : '-' ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>
<?= $this->endSection() ?>
