<?= $this->extend('layouts/superadmin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>License Keys</h2>
    <a href="/superadmin/licenses/create" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Create New License
    </a>
</div>

<div class="card">
    <div class="card-body">
        <table class="table table-hover" id="licensesTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Code</th>
                    <th>Organization</th>
                    <th>Status</th>
                    <th>Seats</th>
                    <th>Valid Until</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($licenses as $i => $license): ?>
                <tr>
                    <td><?= $i + 1 ?></td>
                    <td><code><?= esc($license['license_code']) ?></code></td>
                    <td><?= esc($license['organization_name']) ?></td>
                    <td>
                        <span class="badge bg-<?= $license['status'] == 'active' ? 'success' : ($license['status'] == 'expired' ? 'danger' : 'secondary') ?>">
                            <?= esc(ucfirst($license['status'])) ?>
                        </span>
                    </td>
                    <td>
                        <?= $license['used_seats'] ?> / 
                        <?= $license['max_seats'] == -1 ? 'Unlimited' : $license['max_seats'] ?>
                    </td>
                    <td><?= $license['valid_until'] ? date('M d, Y', strtotime($license['valid_until'])) : '-' ?></td>
                    <td>
                        <a href="/superadmin/licenses/show/<?= $license['id'] ?>" class="btn btn-sm btn-info text-white">
                            <i class="bi bi-eye"></i>
                        </a>
                        <a href="/superadmin/licenses/edit/<?= $license['id'] ?>" class="btn btn-sm btn-warning">
                            <i class="bi bi-pencil"></i>
                        </a>
                        <a href="/superadmin/licenses/delete/<?= $license['id'] ?>" class="btn btn-sm btn-danger" 
                           onclick="return confirm('Are you sure you want to delete this license?')">
                            <i class="bi bi-trash"></i>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?= $this->endSection() ?>
