<?= $this->extend('layouts/superadmin') ?>

<?= $this->section('content') ?>
<h2 class="mb-4">Edit License Key</h2>

<div class="card">
    <div class="card-body">
        <form action="/superadmin/licenses/update/<?= $license['id'] ?>" method="post">
            <div class="row">
                <div class="col-md-6">
                    <h5 class="mb-3">License Details</h5>
                    
                    <div class="mb-3">
                        <label class="form-label">License Code (16-digit)</label>
                        <div class="input-group">
                            <input type="text" value="<?= esc($license['license_code']) ?>" class="form-control" readonly>
                            <button type="button" class="btn btn-outline-secondary" onclick="navigator.clipboard.writeText('<?= esc($license['license_code']) ?>'); alert('Copied!');">Copy</button>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Organization Name</label>
                        <input type="text" name="organization_name" class="form-control" value="<?= esc($license['organization_name']) ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Contact Email</label>
                        <input type="email" name="contact_email" class="form-control" value="<?= esc($license['contact_email'] ?? '') ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Contact Phone</label>
                        <input type="text" name="contact_phone" class="form-control" value="<?= esc($license['contact_phone'] ?? '') ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="active" <?= $license['status'] == 'active' ? 'selected' : '' ?>>Active</option>
                            <option value="expired" <?= $license['status'] == 'expired' ? 'selected' : '' ?>>Expired</option>
                            <option value="disabled" <?= $license['status'] == 'disabled' ? 'selected' : '' ?>>Disabled</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Max Seats (-1 for unlimited)</label>
                        <input type="number" name="max_seats" class="form-control" value="<?= $license['max_seats'] ?>" min="-1" max="50000">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Used Seats</label>
                        <input type="text" class="form-control" value="<?= $license['used_seats'] ?>" readonly>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Valid From</label>
                            <input type="date" name="valid_from" class="form-control" value="<?= $license['valid_from'] ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Valid Until</label>
                            <input type="date" name="valid_until" class="form-control" value="<?= $license['valid_until'] ?>">
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Notes</label>
                        <textarea name="notes" class="form-control" rows="3"><?= esc($license['notes']) ?></textarea>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <h5 class="mb-3">Settings</h5>
                    
                    <div class="mb-3">
                        <label class="form-label">Login Screen</label>
                        <div class="form-check form-switch">
                            <input type="checkbox" name="enable_login_screen" value="yes" class="form-check-input" id="loginScreen" <?= $license['enable_login_screen'] ? 'checked' : '' ?>>
                            <label class="form-check-label" for="loginScreen">Show login screen</label>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Camera Detection</label>
                        <div class="form-check form-switch">
                            <input type="checkbox" name="enable_camera_detection" value="yes" class="form-check-input" id="cameraDetection" <?= $license['enable_camera_detection'] ? 'checked' : '' ?>>
                            <label class="form-check-label" for="cameraDetection">Detect Camera</label>
                        </div>
                    </div>
                    
                    <div class="mb-3" id="personDetectionGroup">
                        <label class="form-label">Person Detection</label>
                        <div class="form-check form-switch">
                            <input type="checkbox" name="enable_person_detection" value="yes" class="form-check-input" id="personDetection" <?= $license['enable_person_detection'] ? 'checked' : '' ?>>
                            <label class="form-check-label" for="personDetection">Detect Person</label>
                        </div>
                        <small class="text-muted">Only enabled when camera detection is on</small>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Screenshot Needed</label>
                        <div class="form-check form-switch">
                            <input type="checkbox" name="screenshot_needed" value="yes" class="form-check-input" id="screenshotNeeded" <?= ($license['screenshot_needed'] ?? false) ? 'checked' : '' ?>>
                            <label class="form-check-label" for="screenshotNeeded">Enable Screenshot</label>
                        </div>
                    </div>
                    
                    <h5 class="mb-3 mt-4">URL Settings</h5>
                    
                    <div class="mb-3">
                        <label class="form-label">LMS Probe Origin URL</label>
                        <input type="url" name="lms_probe_origin" class="form-control" value="<?= esc($license['lms_probe_origin'] ?? '') ?>" placeholder="https://example.lms.hr.cloud.sap/">
                        <small class="text-muted">Default open URL for LMS</small>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">SAP Web URL</label>
                        <input type="url" name="sap_web_url" class="form-control" value="<?= esc($license['sap_web_url'] ?? '') ?>" placeholder="https://example.hr.cloud.sap/sf/home">
                        <small class="text-muted">Sapple popup URL</small>
                    </div>
                </div>
            </div>
            
            <hr>
            <button type="submit" class="btn btn-primary">Update License</button>
            <a href="/superadmin/licenses" class="btn btn-outline-secondary">Cancel</a>
        </form>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
document.getElementById('cameraDetection').addEventListener('change', function() {
    const personGroup = document.getElementById('personDetectionGroup');
    const personCheckbox = document.getElementById('personDetection');
    if (!this.checked) {
        personCheckbox.checked = false;
        personCheckbox.disabled = true;
        personGroup.style.opacity = '0.5';
    } else {
        personCheckbox.disabled = false;
        personGroup.style.opacity = '1';
    }
});

// Check initial state
if (!document.getElementById('cameraDetection').checked) {
    document.getElementById('personDetection').disabled = true;
    document.getElementById('personDetectionGroup').style.opacity = '0.5';
}
</script>
<?= $this->endSection() ?>
