<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Admin Panel' ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        .sidebar { min-height: 100vh; background: #1a5276; }
        .sidebar a { color: #ecf0f1; text-decoration: none; padding: 12px 20px; display: block; }
        .sidebar a:hover, .sidebar a.active { background: #21618c; }
        .main-content { background: #f8f9fa; min-height: 100vh; }
        .card { border: none; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-2 sidebar p-0">
                <div class="p-3 text-white text-center border-bottom border-secondary">
                    <h5><i class="bi bi-person-gear"></i> Admin Panel</h5>
                </div>
                <?php
                    $showLoginScreen = true;
                    $licenseId = session()->get('admin_license_id');
                    if ($licenseId) {
                        $licenseModel = new \App\Models\LicenseKeyModel();
                        $license = $licenseModel->find($licenseId);
                        if ($license) {
                            $showLoginScreen = (bool) $license['enable_login_screen'];
                        }
                    }
                ?>
                <nav class="mt-3">
                    <a href="/admin/dashboard" class="<?= uri_string() == 'admin/dashboard' ? 'active' : '' ?>">
                        <i class="bi bi-speedometer2"></i> Dashboard
                    </a>
                    <?php if($showLoginScreen): ?>
                    <a href="/admin/users" class="<?= strpos(uri_string(), 'admin/users') !== false ? 'active' : '' ?>">
                        <i class="bi bi-people"></i> User Management
                    </a>
                    <?php endif; ?>
                    <a href="/admin/change-password">
                        <i class="bi bi-lock"></i> Change Password
                    </a>
                    <a href="/admin/logout">
                        <i class="bi bi-box-arrow-right"></i> Logout
                    </a>
                </nav>
            </div>
            <div class="col-md-10 main-content p-4">
                <?php if(session()->getFlashdata('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show">
                        <?= session()->getFlashdata('success') ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                <?php if(session()->getFlashdata('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show">
                        <?= session()->getFlashdata('error') ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                <?= $this->renderSection('content') ?>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <?= $this->renderSection('scripts') ?>
</body>
</html>
