<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>User Management</h2>
    <a href="/admin/users/create" class="btn btn-primary">
        <i class="bi bi-person-plus"></i> Add User
    </a>
</div>

<div class="card">
    <div class="card-body">
        <div class="mb-3">
            <input type="text" class="form-control" id="searchInput" placeholder="Search users...">
        </div>
        <table class="table table-hover" id="usersTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>User ID</th>
                    <th>Full Name</th>
                    <th>Email</th>
                    <th>Department</th>
                    <th>Role</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($users as $i => $user): ?>
                <tr>
                    <td><?= $i + 1 ?></td>
                    <td><?= esc($user['user_id']) ?></td>
                    <td><?= esc($user['full_name']) ?></td>
                    <td><?= esc($user['email']) ?></td>
                    <td><?= esc($user['department']) ?></td>
                    <td>
                        <span class="badge bg-<?= ($user['role'] ?? 'user') == 'admin' ? 'primary' : 'secondary' ?>">
                            <?= ucfirst(esc($user['role'] ?? 'user')) ?>
                        </span>
                    </td>
                    <td>
                        <span class="badge bg-<?= $user['status'] == 'active' ? 'success' : 'danger' ?>">
                            <?= ucfirst(esc($user['status'])) ?>
                        </span>
                    </td>
                    <td>
                        <a href="/admin/users/edit/<?= $user['id'] ?>" class="btn btn-sm btn-warning">
                            <i class="bi bi-pencil"></i>
                        </a>
                        <a href="/admin/users/reset-password/<?= $user['id'] ?>" class="btn btn-sm btn-info text-white" 
                           onclick="return confirm('Are you sure you want to reset this user\'s password?')">
                            <i class="bi bi-key"></i>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
document.getElementById('searchInput').addEventListener('keyup', function() {
    const filter = this.value.toLowerCase();
    const rows = document.querySelectorAll('#usersTable tbody tr');
    rows.forEach(row => {
        const text = row.textContent.toLowerCase();
        row.style.display = text.includes(filter) ? '' : 'none';
    });
});
</script>
<?= $this->endSection() ?>
