<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<h2 class="mb-4">Edit User</h2>

<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header"><h5 class="mb-0">User Information</h5></div>
            <div class="card-body">
                <form action="/admin/users/update/<?= $user['id'] ?>" method="post">
                    <div class="mb-3">
                        <label class="form-label">User Type</label>
                        <div class="form-check">
                            <input type="radio" name="role" value="user" class="form-check-input" id="roleUser" <?= ($user['role'] ?? 'user') == 'user' ? 'checked' : '' ?>>
                            <label class="form-check-label" for="roleUser">Normal User</label>
                        </div>
                        <div class="form-check">
                            <input type="radio" name="role" value="admin" class="form-check-input" id="roleAdmin" <?= ($user['role'] ?? 'user') == 'admin' ? 'checked' : '' ?>>
                            <label class="form-check-label" for="roleAdmin">Admin</label>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">User ID</label>
                        <input type="text" name="user_id" class="form-control" value="<?= esc($user['user_id']) ?>" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Password</label>
                        <div class="input-group">
                            <input type="text" class="form-control" value="********" readonly>
                            <a href="/admin/users/reset-password/<?= $user['id'] ?>" class="btn btn-outline-warning"
                               onclick="return confirm('Are you sure you want to reset this user\'s password?')">
                                Reset Password
                            </a>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Full Name</label>
                        <input type="text" name="full_name" class="form-control" value="<?= esc($user['full_name']) ?>" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" class="form-control" value="<?= esc($user['email']) ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Department</label>
                        <input type="text" name="department" class="form-control" value="<?= esc($user['department']) ?>">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <div class="form-check">
                            <input type="radio" name="status" value="active" class="form-check-input" id="statusActive" <?= $user['status'] == 'active' ? 'checked' : '' ?>>
                            <label class="form-check-label" for="statusActive">Active</label>
                        </div>
                        <div class="form-check">
                            <input type="radio" name="status" value="inactive" class="form-check-input" id="statusInactive" <?= $user['status'] == 'inactive' ? 'checked' : '' ?>>
                            <label class="form-check-label" for="statusInactive">Inactive</label>
                        </div>
                    </div>
                    
                    <hr>
                    <button type="submit" class="btn btn-primary">Update User</button>
                    <a href="/admin/users" class="btn btn-outline-secondary">Cancel</a>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header"><h5 class="mb-0">System Usage (Last 3 Months)</h5></div>
            <div class="card-body">
                <?php if(empty($systemUsage)): ?>
                    <p class="text-muted mb-0">No system usage recorded.</p>
                <?php else: ?>
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>MAC ID</th>
                                <th>IP</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($systemUsage as $i => $usage): ?>
                            <tr>
                                <td><?= $i + 1 ?></td>
                                <td><code><?= esc($usage['mac_id']) ?></code></td>
                                <td><?= esc($usage['ip_address']) ?></td>
                                <td><?= date('M d, Y', strtotime($usage['created_at'])) ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
