<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<h2 class="mb-4">Add New User</h2>

<div class="card" style="max-width: 600px;">
    <div class="card-body">
        <form action="/admin/users/store" method="post">
            <div class="mb-3">
                <label class="form-label">User Type</label>
                <div class="form-check">
                    <input type="radio" name="role" value="user" class="form-check-input" id="roleUser" checked>
                    <label class="form-check-label" for="roleUser">Normal User</label>
                </div>
                <div class="form-check">
                    <input type="radio" name="role" value="admin" class="form-check-input" id="roleAdmin">
                    <label class="form-check-label" for="roleAdmin">Admin</label>
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">User ID</label>
                <input type="text" name="user_id" class="form-control" required>
            </div>
            
            <div class="mb-3">
                <label class="form-label">Full Name</label>
                <input type="text" name="full_name" class="form-control" required>
            </div>
            
            <div class="mb-3">
                <label class="form-label">Email</label>
                <input type="email" name="email" class="form-control">
            </div>
            
            <div class="mb-3">
                <label class="form-label">Password</label>
                <input type="password" name="password" class="form-control" required minlength="6">
            </div>
            
            <div class="mb-3">
                <label class="form-label">Confirm Password</label>
                <input type="password" name="confirm_password" class="form-control" required minlength="6">
            </div>
            
            <div class="mb-3">
                <label class="form-label">Department</label>
                <input type="text" name="department" class="form-control">
            </div>
            
            <div class="mb-3">
                <label class="form-label">Status</label>
                <div class="form-check">
                    <input type="radio" name="status" value="active" class="form-check-input" id="statusActive" checked>
                    <label class="form-check-label" for="statusActive">Active</label>
                </div>
                <div class="form-check">
                    <input type="radio" name="status" value="inactive" class="form-check-input" id="statusInactive">
                    <label class="form-check-label" for="statusInactive">Inactive</label>
                </div>
            </div>
            
            <hr>
            <button type="submit" class="btn btn-primary">Create User</button>
            <a href="/admin/users" class="btn btn-outline-secondary">Cancel</a>
        </form>
    </div>
</div>
<?= $this->endSection() ?>
