<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<h2 class="mb-4">Dashboard</h2>

<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <?= session()->getFlashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="row">
    <div class="col-md-3">
        <div class="card text-center mb-4">
            <div class="card-body">
                <h3 class="text-primary"><?= $totalUsers ?></h3>
                <p class="mb-0">Total Users</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-center mb-4">
            <div class="card-body">
                <h3 class="text-success"><?= $activeUsers ?></h3>
                <p class="mb-0">Active Users</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-center mb-4">
            <div class="card-body">
                <h3 class="text-danger"><?= $disabledUsers ?></h3>
                <p class="mb-0">Disabled Users</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-center mb-4">
            <div class="card-body">
                <h3 class="text-info"><?= $activeSystemsCount ?>/<?= $maxSeats ?></h3>
                <p class="mb-0">Systems Used</p>
            </div>
        </div>
    </div>
</div>

<!-- License Information Card -->
<?php 
// Use cached license data if available (Admin mode), otherwise use direct license
$displayData = $licenseData ?? $license;
$licenseCode = $displayData['license_code'] ?? ($license['license_code'] ?? 'N/A');
$orgName = $displayData['organization_name'] ?? ($license['organization_name'] ?? 'N/A');
$status = $displayData['status'] ?? ($license['status'] ?? 'unknown');
$validUntil = $displayData['valid_until'] ?? ($license['valid_until'] ?? null);
$maxSeatsDisplay = $displayData['max_seats'] ?? ($license['max_seats'] ?? 0);
$enableLogin = $displayData['enable_login_screen'] ?? ($license['enable_login_screen'] ?? false);
$enableCamera = $displayData['enable_camera_detection'] ?? ($license['enable_camera_detection'] ?? false);
$enablePerson = $displayData['enable_person_detection'] ?? ($license['enable_person_detection'] ?? false);
$screenshotNeeded = $displayData['screenshot_needed'] ?? ($license['screenshot_needed'] ?? false);
$lmsProbeOrigin = $displayData['lms_probe_origin'] ?? ($license['lms_probe_origin'] ?? '');
$sapWebUrl = $displayData['sap_web_url'] ?? ($license['sap_web_url'] ?? '');
?>
<div class="card mb-4">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">License Information</h5>
        <a href="/admin/sync-license" class="btn btn-primary btn-sm">
            <i class="bi bi-arrow-repeat"></i> Sync from Super Admin
        </a>
    </div>
    <div class="card-body">
        <?php if ($license || $licenseData): ?>
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm">
                        <tr>
                            <th>License Code:</th>
                            <td><code><?= esc($licenseCode) ?></code></td>
                        </tr>
                        <tr>
                            <th>Organization:</th>
                            <td><?= esc($orgName) ?></td>
                        </tr>
                        <tr>
                            <th>Status:</th>
                            <td>
                                <?php if ($status === 'active'): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                    <span class="badge bg-danger"><?= ucfirst($status) ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>Valid Until:</th>
                            <td><?= $validUntil ? date('M d, Y', strtotime($validUntil)) : 'No expiry' ?></td>
                        </tr>
                        <tr>
                            <th>Max Seats:</th>
                            <td><?= $maxSeatsDisplay ?></td>
                        </tr>
                        <tr>
                            <th>Used Seats:</th>
                            <td><?= $activeSystemsCount ?></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">License Settings</h6>
                    <table class="table table-sm">
                        <tr>
                            <th>Login Screen:</th>
                            <td><?= $enableLogin ? '<span class="badge bg-success">Enabled</span>' : '<span class="badge bg-secondary">Disabled</span>' ?></td>
                        </tr>
                        <tr>
                            <th>Camera Detection:</th>
                            <td><?= $enableCamera ? '<span class="badge bg-success">Enabled</span>' : '<span class="badge bg-secondary">Disabled</span>' ?></td>
                        </tr>
                        <tr>
                            <th>Person Detection:</th>
                            <td><?= $enablePerson ? '<span class="badge bg-success">Enabled</span>' : '<span class="badge bg-secondary">Disabled</span>' ?></td>
                        </tr>
                        <tr>
                            <th>Screenshot Capture:</th>
                            <td><?= $screenshotNeeded ? '<span class="badge bg-success">Enabled</span>' : '<span class="badge bg-secondary">Disabled</span>' ?></td>
                        </tr>
                        <tr>
                            <th>LMS Probe Origin:</th>
                            <td><?= $lmsProbeOrigin ? '<code>' . esc($lmsProbeOrigin) . '</code>' : '<span class="text-muted">Not configured</span>' ?></td>
                        </tr>
                        <tr>
                            <th>SAP Web URL:</th>
                            <td><?= $sapWebUrl ? '<code>' . esc($sapWebUrl) . '</code>' : '<span class="text-muted">Not configured</span>' ?></td>
                        </tr>
                    </table>
                </div>
            </div>
            
            <div class="mt-3 p-3 bg-light rounded">
                <?php if ($licenseCache): ?>
                    <small class="text-muted">
                        <strong>Sync Status:</strong> 
                        Last synced: <?= $licenseCache['synced_at'] ? date('M d, Y H:i', strtotime($licenseCache['synced_at'])) : 'Never' ?>
                        <?php if ($signatureValid): ?>
                            <span class="badge bg-success ms-2">Signature Valid</span>
                        <?php else: ?>
                            <span class="badge bg-danger ms-2">Signature Invalid - Please Sync</span>
                        <?php endif; ?>
                    </small>
                <?php else: ?>
                    <small class="text-warning">
                        <strong>Warning:</strong> License not synced from Super Admin. Click "Sync from Super Admin" to fetch the latest license data.
                    </small>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div class="text-center py-4">
                <p class="text-muted mb-3">No license information available. Please contact Super Admin to assign a license.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Registered Systems Card -->
<?php if (!empty($registeredSystems)): ?>
<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">Registered Systems (<?= count($registeredSystems) ?>)</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-sm table-hover">
                <thead>
                    <tr>
                        <th>MAC Hash</th>
                        <th>IP Address</th>
                        <th>Hostname</th>
                        <th>Status</th>
                        <th>First Seen</th>
                        <th>Last Seen</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($registeredSystems as $system): ?>
                    <tr>
                        <td><code><?= substr($system['mac_hash'], 0, 12) ?>...</code></td>
                        <td><?= esc($system['ip_address'] ?? '-') ?></td>
                        <td><?= esc($system['hostname'] ?? '-') ?></td>
                        <td>
                            <?php if ($system['status'] === 'active'): ?>
                                <span class="badge bg-success">Active</span>
                            <?php elseif ($system['status'] === 'revoked'): ?>
                                <span class="badge bg-danger">Revoked</span>
                            <?php else: ?>
                                <span class="badge bg-secondary"><?= ucfirst($system['status']) ?></span>
                            <?php endif; ?>
                        </td>
                        <td><?= $system['first_seen_at'] ? date('M d, Y', strtotime($system['first_seen_at'])) : '-' ?></td>
                        <td><?= $system['last_seen_at'] ? date('M d, Y H:i', strtotime($system['last_seen_at'])) : '-' ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php endif; ?>

<?php if ($enableLogin): ?>
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Quick Actions</h5>
    </div>
    <div class="card-body">
        <a href="/admin/users/create" class="btn btn-primary me-2">
            <i class="bi bi-person-plus"></i> Add New User
        </a>
        <a href="/admin/users" class="btn btn-outline-primary me-2">
            <i class="bi bi-people"></i> View All Users
        </a>
    </div>
</div>
<?php endif; ?>
<?= $this->endSection() ?>
