<?php

namespace App\Models;

use CodeIgniter\Model;

class UserModel extends Model
{
    protected $table = 'users';
    protected $primaryKey = 'id';
    protected $allowedFields = [
        'license_id', 'admin_id', 'user_id', 'password', 'full_name', 'email',
        'department', 'mac_id', 'status', 'last_login', 'created_at', 'updated_at'
    ];
    protected $useTimestamps = false;
    
    public function verifyPassword($userId, $password, $licenseId)
    {
        $user = $this->where('user_id', $userId)
            ->where('license_id', $licenseId)
            ->where('status', 'active')
            ->first();
        if ($user && password_verify($password, $user['password'])) {
            return $user;
        }
        return false;
    }

    public function getSystemUsage($userId)
    {
        $db = \Config\Database::connect();
        return $db->table('system_usage')
            ->where('user_id', $userId)
            ->where('created_at >=', date('Y-m-d', strtotime('-3 months')))
            ->orderBy('created_at', 'DESC')
            ->get()
            ->getResultArray();
    }
}
