<?php

namespace App\Models;

use CodeIgniter\Model;

class SuperAdminModel extends Model
{
    protected $table = 'super_admins';
    protected $primaryKey = 'id';
    protected $allowedFields = ['username', 'password', 'email', 'status', 'updated_at'];
    protected $useTimestamps = false;
    
    public function verifyPassword($username, $password)
    {
        $admin = $this->where('username', $username)->first();
        if ($admin && password_verify($password, $admin['password'])) {
            return $admin;
        }
        return false;
    }
}
