<?php

namespace App\Models;

use CodeIgniter\Model;

class ReportedSystemModel extends Model
{
    protected $table = 'reported_systems';
    protected $primaryKey = 'id';
    protected $useAutoIncrement = true;
    protected $returnType = 'array';
    protected $allowedFields = [
        'license_id',
        'mac_hash',
        'hostname',
        'ip_address',
        'user_id',
        'user_name',
        'admin_source',
        'first_seen_at',
        'last_seen_at',
        'status',
    ];
    protected $useTimestamps = true;
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';

    public function getByLicense(int $licenseId): array
    {
        return $this->where('license_id', $licenseId)
                    ->orderBy('last_seen_at', 'DESC')
                    ->findAll();
    }

    public function getActiveByLicense(int $licenseId): array
    {
        return $this->where('license_id', $licenseId)
                    ->where('status', 'active')
                    ->orderBy('last_seen_at', 'DESC')
                    ->findAll();
    }

    public function countActiveByLicense(int $licenseId): int
    {
        return $this->where('license_id', $licenseId)
                    ->where('status', 'active')
                    ->countAllResults();
    }
}
