<?php

namespace App\Models;

use CodeIgniter\Model;

class AuditLogModel extends Model
{
    protected $table = 'audit_logs';
    protected $primaryKey = 'id';
    protected $allowedFields = [
        'user_type', 'user_id', 'action', 'table_name', 
        'record_id', 'old_data', 'new_data', 'ip_address'
    ];
    protected $useTimestamps = false;

    public function log($userType, $userId, $action, $tableName = null, $recordId = null, $oldData = null, $newData = null)
    {
        $this->insert([
            'user_type' => $userType,
            'user_id' => $userId,
            'action' => $action,
            'table_name' => $tableName,
            'record_id' => $recordId,
            'old_data' => $oldData ? json_encode($oldData) : null,
            'new_data' => $newData ? json_encode($newData) : null,
            'ip_address' => $_SERVER['REMOTE_ADDR'] ?? null
        ]);
    }
}
