<?php

namespace App\Models;

use CodeIgniter\Model;

class AdminSettingsModel extends Model
{
    protected $table = 'admin_settings';
    protected $primaryKey = 'id';
    protected $allowedFields = [
        'admin_id', 'license_key', 'allow_login', 
        'camera_detection', 'person_detection', 'updated_at'
    ];
    protected $useTimestamps = false;

    public function getOrCreate($adminId)
    {
        $settings = $this->where('admin_id', $adminId)->first();
        if (!$settings) {
            $this->insert([
                'admin_id' => $adminId,
                'allow_login' => true,
                'camera_detection' => true,
                'person_detection' => true
            ]);
            $settings = $this->where('admin_id', $adminId)->first();
        }
        return $settings;
    }
}
