<?php

namespace App\Models;

use CodeIgniter\Model;

class AdminModel extends Model
{
    protected $table = 'admins';
    protected $primaryKey = 'id';
    protected $allowedFields = [
        'license_id', 'username', 'password', 'full_name', 'email',
        'phone', 'department', 'role', 'status', 'created_by', 'updated_at'
    ];
    protected $useTimestamps = false;
    
    public function verifyPassword($username, $password)
    {
        $admin = $this->where('username', $username)->where('status', 'active')->first();
        if ($admin && password_verify($password, $admin['password'])) {
            return $admin;
        }
        return false;
    }
}
