<?php

namespace App\Database\Seeds\SuperAdmin;

use CodeIgniter\Database\Seeder;

class SuperAdminSeeder extends Seeder
{
    public function run()
    {
        // Create default super admin
        $data = [
            'username' => 'superadmin',
            'password' => password_hash('password', PASSWORD_DEFAULT),
            'email' => 'superadmin@example.com',
            'full_name' => 'Super Administrator',
            'status' => 'active',
            'created_at' => date('Y-m-d H:i:s'),
        ];

        $existing = $this->db->table('super_admins')
            ->where('username', 'superadmin')
            ->get()
            ->getRow();

        if (!$existing) {
            $this->db->table('super_admins')->insert($data);
            echo "Default Super Admin created:\n";
            echo "  Username: superadmin\n";
            echo "  Password: password\n";
            echo "\nPlease change the password after first login!\n";
        } else {
            echo "Super Admin 'superadmin' already exists. Skipping.\n";
        }
    }
}
