<?php

namespace App\Database\Seeds\Admin;

use CodeIgniter\Database\Seeder;

class AdminSeeder extends Seeder
{
    public function run()
    {
        echo "Admin Deployment Setup\n";
        echo "======================\n\n";
        echo "For Admin deployments, you should NOT seed data directly.\n";
        echo "Instead, follow these steps:\n\n";
        echo "1. Configure your .env file with:\n";
        echo "   - app.context = admin\n";
        echo "   - superadmin.apiUrl = https://your-superadmin-server.com\n";
        echo "   - superadmin.apiKey = your-api-key\n";
        echo "   - license.publicKey = (base64 encoded public key from Super Admin)\n\n";
        echo "2. Access /admin/login and click 'Register as Admin'\n";
        echo "3. Enter your license code provided by Super Admin\n";
        echo "4. Create your admin account credentials\n\n";
        echo "The system will automatically:\n";
        echo "   - Validate your license with Super Admin\n";
        echo "   - Fetch and cache the signed license data\n";
        echo "   - Create your admin account\n\n";
        echo "No manual seeding required!\n";
    }
}
