<?php

namespace App\Database\Migrations\SuperAdmin;

use CodeIgniter\Database\Migration;

class CreateSuperAdminTables extends Migration
{
    public function up()
    {
        // Super Admins table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'username' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
            ],
            'password' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],
            'email' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
            ],
            'full_name' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
            ],
            'status' => [
                'type' => 'ENUM',
                'constraint' => ['active', 'inactive'],
                'default' => 'active',
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addUniqueKey('username');
        $this->forge->createTable('super_admins', true);

        // License Keys table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'license_code' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
            ],
            'organization_name' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],
            'max_seats' => [
                'type' => 'INT',
                'constraint' => 11,
                'default' => -1,
            ],
            'used_seats' => [
                'type' => 'INT',
                'constraint' => 11,
                'default' => 0,
            ],
            'valid_from' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'valid_until' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'enable_login_screen' => [
                'type' => 'TINYINT',
                'constraint' => 1,
                'default' => 0,
            ],
            'enable_camera_detection' => [
                'type' => 'TINYINT',
                'constraint' => 1,
                'default' => 0,
            ],
            'enable_person_detection' => [
                'type' => 'TINYINT',
                'constraint' => 1,
                'default' => 0,
            ],
            'screenshot_needed' => [
                'type' => 'TINYINT',
                'constraint' => 1,
                'default' => 0,
            ],
            'lms_probe_origin' => [
                'type' => 'VARCHAR',
                'constraint' => 500,
                'null' => true,
            ],
            'sap_web_url' => [
                'type' => 'VARCHAR',
                'constraint' => 500,
                'null' => true,
            ],
            'status' => [
                'type' => 'ENUM',
                'constraint' => ['active', 'inactive', 'expired', 'suspended'],
                'default' => 'active',
            ],
            'notes' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addUniqueKey('license_code');
        $this->forge->createTable('license_keys', true);

        // Reported Systems table (systems reported by Admin deployments)
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'license_code' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
            ],
            'mac_hash' => [
                'type' => 'VARCHAR',
                'constraint' => 64,
            ],
            'hostname' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
            ],
            'ip_address' => [
                'type' => 'VARCHAR',
                'constraint' => 45,
                'null' => true,
            ],
            'user_id' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => true,
            ],
            'user_name' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
            ],
            'admin_source' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
            ],
            'status' => [
                'type' => 'ENUM',
                'constraint' => ['active', 'inactive', 'revoked'],
                'default' => 'active',
            ],
            'first_seen_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'last_seen_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addKey('license_code');
        $this->forge->addKey('mac_hash');
        $this->forge->createTable('reported_systems', true);

        // Audit Logs table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'actor_type' => [
                'type' => 'ENUM',
                'constraint' => ['super_admin', 'admin', 'system', 'api'],
                'default' => 'system',
            ],
            'actor_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'null' => true,
            ],
            'action' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],
            'entity_type' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => true,
            ],
            'entity_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'null' => true,
            ],
            'old_data' => [
                'type' => 'JSON',
                'null' => true,
            ],
            'new_data' => [
                'type' => 'JSON',
                'null' => true,
            ],
            'ip_address' => [
                'type' => 'VARCHAR',
                'constraint' => 45,
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addKey('actor_type');
        $this->forge->addKey('entity_type');
        $this->forge->createTable('audit_logs', true);
    }

    public function down()
    {
        $this->forge->dropTable('audit_logs', true);
        $this->forge->dropTable('reported_systems', true);
        $this->forge->dropTable('license_keys', true);
        $this->forge->dropTable('super_admins', true);
    }
}
