<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddNewLicenseFields extends Migration
{
    public function up()
    {
        $this->forge->addColumn('license_keys', [
            'lms_probe_origin' => [
                'type' => 'VARCHAR',
                'constraint' => 500,
                'null' => true,
                'after' => 'enable_person_detection',
            ],
            'screenshot_needed' => [
                'type' => 'TINYINT',
                'constraint' => 1,
                'default' => 0,
                'after' => 'lms_probe_origin',
            ],
            'sap_web_url' => [
                'type' => 'VARCHAR',
                'constraint' => 500,
                'null' => true,
                'after' => 'screenshot_needed',
            ],
        ]);
    }

    public function down()
    {
        $this->forge->dropColumn('license_keys', ['lms_probe_origin', 'screenshot_needed', 'sap_web_url']);
    }
}
