<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateLicenseCacheTables extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'admin_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
            ],
            'license_code' => [
                'type' => 'VARCHAR',
                'constraint' => 20,
            ],
            'license_data' => [
                'type' => 'TEXT',
            ],
            'signature' => [
                'type' => 'TEXT',
            ],
            'signed_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'synced_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addKey('admin_id');
        $this->forge->addKey('license_code');
        $this->forge->createTable('admin_license_cache', true);

        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'license_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'null' => true,
            ],
            'mac_hash' => [
                'type' => 'VARCHAR',
                'constraint' => 64,
            ],
            'ip_address' => [
                'type' => 'VARCHAR',
                'constraint' => 45,
                'null' => true,
            ],
            'hostname' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
            ],
            'user_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'null' => true,
            ],
            'status' => [
                'type' => 'ENUM',
                'constraint' => ['active', 'inactive', 'revoked'],
                'default' => 'active',
            ],
            'first_seen_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'last_seen_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addKey('license_id');
        $this->forge->addKey('mac_hash');
        $this->forge->addForeignKey('license_id', 'license_keys', 'id', 'SET NULL', 'CASCADE');
        $this->forge->createTable('registered_systems', true);
    }

    public function down()
    {
        $this->forge->dropTable('registered_systems', true);
        $this->forge->dropTable('admin_license_cache', true);
    }
}
