<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

$routes->get('/', 'Home::index');

// Super Admin Routes - Public
$routes->get('superadmin/login', 'SuperAdmin\Auth::login');
$routes->post('superadmin/authenticate', 'SuperAdmin\Auth::authenticate');

// Super Admin Routes - Protected
$routes->group('superadmin', ['filter' => 'superadmin'], function($routes) {
    $routes->get('logout', 'SuperAdmin\Auth::logout');
    $routes->get('dashboard', 'SuperAdmin\Dashboard::index');
    $routes->get('change-password', 'SuperAdmin\Auth::changePassword');
    $routes->post('update-password', 'SuperAdmin\Auth::updatePassword');
    
    // License Keys
    $routes->get('licenses', 'SuperAdmin\LicenseKeys::index');
    $routes->get('licenses/create', 'SuperAdmin\LicenseKeys::create');
    $routes->post('licenses/store', 'SuperAdmin\LicenseKeys::store');
    $routes->get('licenses/generate-code', 'SuperAdmin\LicenseKeys::generateCode');
    $routes->get('licenses/show/(:num)', 'SuperAdmin\LicenseKeys::show/$1');
    $routes->get('licenses/edit/(:num)', 'SuperAdmin\LicenseKeys::edit/$1');
    $routes->post('licenses/update/(:num)', 'SuperAdmin\LicenseKeys::update/$1');
    $routes->get('licenses/delete/(:num)', 'SuperAdmin\LicenseKeys::delete/$1');
    
    // Reported Systems
    $routes->get('reported-systems', 'SuperAdmin\ReportedSystems::index');
});

// Admin Routes - Public
$routes->get('admin/login', 'Admin\Auth::login');
$routes->post('admin/authenticate', 'Admin\Auth::authenticate');
$routes->post('admin/register', 'Admin\Auth::register');

// Admin Routes - Protected
$routes->group('admin', ['filter' => 'admin'], function($routes) {
    $routes->get('logout', 'Admin\Auth::logout');
    $routes->get('dashboard', 'Admin\Dashboard::index');
    $routes->get('change-password', 'Admin\Auth::changePassword');
    $routes->post('update-password', 'Admin\Auth::updatePassword');
    
    // Users
    $routes->get('users', 'Admin\Users::index');
    $routes->get('users/create', 'Admin\Users::create');
    $routes->post('users/store', 'Admin\Users::store');
    $routes->get('users/edit/(:num)', 'Admin\Users::edit/$1');
    $routes->post('users/update/(:num)', 'Admin\Users::update/$1');
    $routes->get('users/reset-password/(:num)', 'Admin\Users::resetPassword/$1');
    
    // License Sync
    $routes->get('sync-license', 'Admin\Dashboard::syncLicense');
    $routes->post('sync-license', 'Admin\Dashboard::syncLicense');
});

// API Routes
$routes->group('api', function($routes) {
    // Super Admin API - License fetch with signature (for Admin deployments to sync)
    $routes->match(['get', 'post'], 'license/fetch', 'Api\LicenseFetch::fetchLicense');
    $routes->match(['get', 'post'], 'license/sync', 'Api\LicenseFetch::syncLicense');
    $routes->post('license/verify-signature', 'Api\LicenseFetch::validateSignature');
    
    // Super Admin API - Receive system reports from Admin deployments
    $routes->post('system/report', 'Api\SystemReport::receiveReport');
    $routes->match(['get', 'post'], 'system/list', 'Api\SystemReport::getSystemsByLicense');
    
    // Desktop App Authentication API
    $routes->post('desktop/authenticate', 'Api\DesktopAuth::authenticate');
    $routes->post('desktop/login', 'Api\DesktopAuth::login');
});
