<?php

namespace Config;

use CodeIgniter\Config\BaseConfig;

class Deployment extends BaseConfig
{
    public string $context = 'superadmin';
    public string $superAdminApiUrl = '';
    public string $privateKey = '';
    public string $publicKey = '';

    public function __construct()
    {
        parent::__construct();
        
        $this->context = env('app.context', 'superadmin');
        $this->superAdminApiUrl = env('superadmin.apiUrl', '');
        $this->privateKey = env('license.privateKey', '');
        $this->publicKey = env('license.publicKey', '');
    }

    public function isSuperAdmin(): bool
    {
        return $this->context === 'superadmin';
    }

    public function isAdmin(): bool
    {
        return $this->context === 'admin';
    }
}
