<?php

namespace App\Commands;

use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use App\Libraries\SignatureService;

class GenerateKeys extends BaseCommand
{
    protected $group       = 'License';
    protected $name        = 'license:generate-keys';
    protected $description = 'Generate RSA key pair for license signing';

    public function run(array $params)
    {
        CLI::write('Generating RSA 2048-bit key pair...', 'yellow');
        
        $keys = SignatureService::generateKeyPair();
        
        CLI::newLine();
        CLI::write('=== RSA KEYS GENERATED SUCCESSFULLY ===', 'green');
        CLI::newLine();
        
        CLI::write('PRIVATE KEY (Super Admin deployment only):', 'yellow');
        CLI::write('Add this to your .env file on Super Admin server:', 'white');
        CLI::newLine();
        CLI::write('license.privateKey = ' . $keys['private_key'], 'cyan');
        CLI::newLine();
        
        CLI::write('PUBLIC KEY (Both Super Admin and Admin deployments):', 'yellow');
        CLI::write('Add this to your .env file on ALL servers:', 'white');
        CLI::newLine();
        CLI::write('license.publicKey = ' . $keys['public_key'], 'cyan');
        CLI::newLine();
        
        CLI::write('=== IMPORTANT ===', 'red');
        CLI::write('1. Keep the PRIVATE KEY secret - only on Super Admin server', 'white');
        CLI::write('2. The PUBLIC KEY can be shared - add to all Admin deployments', 'white');
        CLI::write('3. Never commit these keys to version control', 'white');
        CLI::newLine();
    }
}
